document.addEventListener('DOMContentLoaded', function() {
    // ページ内のすべての株価キャンバスを取得
    const canvases = document.querySelectorAll('.ssc-stock-canvas');

    // ★ここに取得した Alpha Vantage の無料APIキーを入力してください
    const API_KEY = 'KEYR87Z0J4QER9YWRX5';

    canvases.forEach(canvas => {
        const symbol = canvas.getAttribute('data-symbol');
        fetchStockData(symbol, canvas, API_KEY);
    });
});

async function fetchStockData(symbol, canvas, apiKey) {
    // Alpha Vantage APIのエンドポイント (日足データ)
    const url = `https://www.alphavantage.co/query?function=TIME_SERIES_DAILY&symbol=${symbol}&apikey=${apiKey}`;

    try {
        const response = await fetch(url);
        const data = await response.json();

        if (data['Error Message'] || data['Note']) {
            console.error('APIエラー:', data);
            document.getElementById(`ssc-current-price-${symbol}`).innerText = 'データ取得エラー';
            return;
        }

        const timeSeries = data['Time Series (Daily)'];
        const dates = Object.keys(timeSeries);
        
        // 最新の2日分のデータを取得して計算
        const latestDate = dates[0];
        const previousDate = dates[1];

        const currentPrice = parseFloat(timeSeries[latestDate]['4. close']);
        const previousPrice = parseFloat(timeSeries[previousDate]['4. close']);

        // 前日比の計算 (パーセント)
        const changeAmount = currentPrice - previousPrice;
        const changePercent = (changeAmount / previousPrice) * 100;

        // 画面に株価と前日比を表示
        const priceEl = document.getElementById(`ssc-current-price-${symbol}`);
        const changeEl = document.getElementById(`ssc-change-${symbol}`);

        priceEl.innerText = `$${currentPrice.toFixed(2)}`;
        
        let changeText = `${changePercent > 0 ? '+' : ''}${changePercent.toFixed(2)}%`;
        changeEl.innerText = `(${changeAmount > 0 ? '+' : ''}${changeAmount.toFixed(2)} / ${changeText})`;
        changeEl.style.color = changeAmount >= 0 ? 'green' : 'red';

        // チャート用のデータ準備 (直近30日分を古い順に並び替え)
        const chartDates = dates.slice(0, 30).reverse();
        const chartPrices = chartDates.map(date => parseFloat(timeSeries[date]['4. close']));

        // Chart.jsでグラフを描画
        new Chart(canvas, {
            type: 'line',
            data: {
                labels: chartDates,
                datasets: [{
                    label: `${symbol} 終値`,
                    data: chartPrices,
                    borderColor: 'rgba(54, 162, 235, 1)',
                    backgroundColor: 'rgba(54, 162, 235, 0.2)',
                    borderWidth: 2,
                    fill: true,
                    tension: 0.1
                }]
            },
            options: {
                responsive: true,
                scales: {
                    x: { display: true },
                    y: { display: true }
                }
            }
        });

    } catch (error) {
        console.error('通信エラー:', error);
        document.getElementById(`ssc-current-price-${symbol}`).innerText = '通信エラー';
    }
}